/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.overworld;

import com.mojang.serialization.Codec;
import corgiaoc.byg.BYG;
import corgiaoc.byg.common.world.feature.config.BoulderConfig;
import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.Tags;

public class StackableBoulders
extends Feature<BoulderConfig> {
    protected long seed;
    protected static FastNoise fastNoise;
    public static int stopSpamInt;

    public StackableBoulders(Codec<BoulderConfig> configCodec) {
        super(configCodec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos position, BoulderConfig config) {
        this.setSeed(world.func_72905_C());
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)position.func_177979_c(2 + random.nextInt(10)));
        BlockPos.Mutable mutable2 = new BlockPos.Mutable().func_189533_g((Vector3i)mutable);
        int stackHeight = random.nextInt(config.getMaxPossibleHeight()) + config.getMinHeight();
        int radius = random.nextInt(config.getMaxPossibleRadius()) + config.getMinRadius();
        BlockState blockStateDown = world.func_180495_p(position.func_177977_b());
        BlockState blockStateAtPosition = world.func_180495_p(position);
        if (blockStateDown.func_235714_a_((ITag)BlockTags.field_206952_E) || blockStateDown.func_235714_a_((ITag)BlockTags.field_200031_h) || blockStateAtPosition.func_235714_a_((ITag)BlockTags.field_206952_E) || blockStateAtPosition.func_235714_a_((ITag)BlockTags.field_200031_h) || blockStateAtPosition.func_185904_a() == Material.field_151579_a) {
            return false;
        }
        for (int boulderIDX = 0; boulderIDX < stackHeight; ++boulderIDX) {
            int moveOnX = random.nextInt(4);
            if (random.nextInt(2) == 0) {
                moveOnX = -moveOnX;
            }
            int moveOnZ = random.nextInt(4);
            if (random.nextInt(2) == 1) {
                moveOnZ = -moveOnZ;
            }
            mutable.func_196234_d(moveOnX, (int)((float)random.nextInt(Math.abs(radius) + 1) * 0.2f + (float)radius * 0.8f) - 3 + -random.nextInt(5), moveOnZ);
            int yPositiveRadius = config.isTopBoulderFlat() && boulderIDX + 1 == stackHeight ? 0 : radius;
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= yPositiveRadius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        BlockState blockState;
                        int squaredDistance = x * x + y * y + z * z;
                        if (squaredDistance > radius * radius) continue;
                        mutable2.func_189533_g((Vector3i)mutable).func_196234_d(x, y, z);
                        double boulderRoughnessNoise = fastNoise.GetNoise((float)mutable2.func_177958_n() * 0.04f, (float)mutable2.func_177956_o() * 0.01f, (float)mutable2.func_177952_p() * 0.04f);
                        if ((float)squaredDistance > (float)(radius * radius) * 0.8f && boulderRoughnessNoise > -0.3 && boulderRoughnessNoise < 0.3 || !this.canBlockPlaceHere(blockState = world.func_180495_p((BlockPos)mutable2))) continue;
                        world.func_180501_a((BlockPos)mutable2, config.getBlockProvider().func_225574_a_(random, (BlockPos)mutable2), 3);
                    }
                }
            }
            while (mutable.func_177956_o() < world.func_217301_I() && !world.func_180495_p((BlockPos)mutable).func_196958_f()) {
                mutable.func_189536_c(Direction.UP);
            }
            if (3 <= (radius = (int)((double)radius / config.getRadiusDivisorPerStack()))) continue;
            if (stopSpamInt != 0) break;
            BYG.LOGGER.debug("BYG: Boulder Radius is too small to continue stacking! Stack stopping at stack height: " + boulderIDX + "\nPlease lower the stack height or increase the boulder radius.");
            ++stopSpamInt;
            break;
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
            this.seed = seed;
        }
    }

    private boolean canBlockPlaceHere(BlockState state) {
        return state.func_196958_f() || state.func_185904_a() == Material.field_151578_c || state.func_185904_a() == Material.field_151585_k || state.func_185904_a() == Material.field_151582_l || state.func_185904_a() == Material.field_151584_j || state.func_185904_a() == Material.field_151595_p || state.func_185904_a() == Material.field_215713_z || state.func_185904_a() == Material.field_151570_A || state.func_185904_a() == Material.field_151586_h || state.func_185904_a() == Material.field_151587_i || state.func_235714_a_((ITag)Tags.Blocks.DIRT);
    }

    static {
        stopSpamInt = 0;
    }
}

