/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.surfacebuilder;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class CragGardensSB
extends SurfaceBuilder<SurfaceBuilderConfig> {
    protected long noiseSeed;
    protected PerlinNoiseGenerator noiseGen;

    public CragGardensSB(Codec<SurfaceBuilderConfig> p_i51310_1_) {
        super(p_i51310_1_);
    }

    public void func_205548_a(long seed) {
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom(seed);
        if (this.noiseSeed != seed || this.noiseGen == null) {
            this.noiseGen = new PerlinNoiseGenerator(sharedseedrandom, (List)ImmutableList.of((Object)0));
        }
        this.noiseSeed = seed;
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        this.buildSurface(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, config.func_204108_a(), config.func_204109_b(), config.func_204110_c(), seaLevel);
    }

    protected void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int xStart, int zStart, int landHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, BlockState topBlock, BlockState middleBlock, BlockState bottomBlock, int seaLevel) {
        int x = xStart & 0xF;
        int z = zStart & 0xF;
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable();
        double baseRangeHeightMultiplier = 5.0;
        double samplePerlin1 = (this.noiseGen.func_215464_a((double)xStart * 0.01, (double)zStart * 0.01, true) + 1.0) * baseRangeHeightMultiplier;
        double samplePerlin2 = (this.noiseGen.func_215464_a((double)xStart * 0.007, (double)zStart * 0.007, true) + 1.0) * baseRangeHeightMultiplier;
        int noise1 = (int)samplePerlin1 * 5;
        int noise2 = (int)samplePerlin2 * 3;
        int noise3 = (int)Math.abs(noise);
        int startHeight = noise1 + noise2 + 40;
        int biomeFloor = (int)(biomeIn.func_185355_j() * biomeIn.func_185360_m());
        int surfaceFloorDiff = landHeight - biomeFloor;
        int maxNoise = surfaceFloorDiff - 18;
        if (noise > 4.0) {
            noise3 = maxNoise;
        }
        int heightSnapshot = landHeight - 18 - noise3;
        if (landHeight > 0) {
            if (heightSnapshot < 0) {
                heightSnapshot = 0;
            }
            for (int y = heightSnapshot; y <= startHeight; ++y) {
                blockpos$Mutable.func_181079_c(x, y, z);
                if (y <= landHeight - 3 - random.nextInt(6)) {
                    chunkIn.func_177436_a((BlockPos)blockpos$Mutable, bottomBlock, false);
                    continue;
                }
                if (y == startHeight && random.nextInt(3) == 0) {
                    chunkIn.func_177436_a((BlockPos)blockpos$Mutable, topBlock, false);
                    continue;
                }
                chunkIn.func_177436_a((BlockPos)blockpos$Mutable, middleBlock, false);
            }
        }
    }
}

