/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.surfacebuilder;

import com.mojang.serialization.Codec;
import corgiaoc.byg.util.noise.fastnoise.FNVector3f;
import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class StoneForestSB
extends SurfaceBuilder<SurfaceBuilderConfig> {
    public static FastNoise noiseGen = null;
    public static FastNoise noiseGen3D = null;

    public StoneForestSB(Codec<SurfaceBuilderConfig> codec) {
        super(codec);
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        this.func_205548_a(random.nextLong());
        int xPos = x & 0xF;
        int zPos = z & 0xF;
        BlockPos.Mutable mutable = new BlockPos.Mutable(xPos, 0, zPos);
        FNVector3f fnVector3f = new FNVector3f(x, 0.0f, z);
        noiseGen.GradientPerturb(fnVector3f);
        float sampleNoise = noiseGen.GetNoise(fnVector3f.x, fnVector3f.z);
        int groundLevel = chunkIn.func_201576_a(Heightmap.Type.OCEAN_FLOOR_WG, x, z);
        if ((double)sampleNoise < 0.43) {
            int topHeight = startHeight + 55;
            mutable.func_189534_c(Direction.UP, topHeight);
            for (int yPos = topHeight; yPos >= groundLevel; --yPos) {
                if (yPos == topHeight) {
                    chunkIn.func_177436_a((BlockPos)mutable, config.func_204108_a(), false);
                } else {
                    chunkIn.func_177436_a((BlockPos)mutable, config.func_204109_b(), false);
                }
                mutable.func_189536_c(Direction.DOWN);
            }
        } else if ((double)sampleNoise < 0.48) {
            int topHeight = startHeight + 44;
            mutable.func_189534_c(Direction.UP, topHeight);
            for (int yPos = topHeight; yPos >= groundLevel; --yPos) {
                if (yPos == topHeight) {
                    chunkIn.func_177436_a((BlockPos)mutable, config.func_204108_a(), false);
                } else {
                    double noise3D = noiseGen3D.GetNoise(x, yPos, z);
                    if (noise3D < 0.4) {
                        chunkIn.func_177436_a((BlockPos)mutable, config.func_204109_b(), false);
                    }
                }
                mutable.func_189536_c(Direction.DOWN);
            }
        } else {
            SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(config.func_204108_a(), config.func_204109_b(), config.func_204110_c()));
        }
    }

    public void func_205548_a(long seed) {
        if (noiseGen == null) {
            noiseGen = new FastNoise((int)seed);
            noiseGen.SetFractalType(FastNoise.FractalType.RigidMulti);
            noiseGen.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            noiseGen.SetGradientPerturbAmp(5.0f);
            noiseGen.SetFractalOctaves(1);
            noiseGen.SetFractalGain(0.3f);
            noiseGen.SetFrequency(0.02f);
        }
        if (noiseGen3D == null) {
            noiseGen3D = new FastNoise((int)seed);
            noiseGen3D.SetNoiseType(FastNoise.NoiseType.Simplex);
            noiseGen3D.SetFractalGain(0.006f);
            noiseGen3D.SetFrequency(0.7f);
        }
    }
}

