/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.config.json.endbiomedata;

import corgiaoc.byg.common.world.biome.BYGEndBiome;
import corgiaoc.byg.common.world.dimension.end.BYGEndBiomeProvider;
import corgiaoc.byg.config.json.endbiomedata.EndBiomeData;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedList;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class EndBiomeDataListHolder {
    List<EndBiomeData> endBiomeData;
    private final List<EndBiomeData> voidBiomeData;

    public EndBiomeDataListHolder(List<EndBiomeData> endBiomeData, List<EndBiomeData> voidBiomeData) {
        this.endBiomeData = endBiomeData;
        this.voidBiomeData = voidBiomeData;
    }

    public List<EndBiomeData> getEndBiomeData() {
        return this.endBiomeData;
    }

    public List<EndBiomeData> getVoidBiomeData() {
        return this.voidBiomeData;
    }

    public static void createDefaults(Registry<Biome> biomeRegistry) {
        for (BYGEndBiome bygBiome : BYGEndBiome.BYG_END_BIOMES) {
            List<BiomeDictionary.Type> typeList = Arrays.asList(bygBiome.getBiomeDictionary());
            typeList.sort(Comparator.comparing(Object::toString));
            BYGEndBiome.endBiomeData.add(new EndBiomeData(WorldGenRegistries.field_243657_i.func_177774_c((Object)bygBiome.getBiome()), bygBiome.getWeight(), typeList.toArray(new BiomeDictionary.Type[0]), bygBiome.getHills(), WorldGenRegistries.field_243657_i.func_177774_c((Object)bygBiome.getEdge())));
        }
        for (ResourceLocation location2 : biomeRegistry.func_148742_b().stream().filter(location -> !location.toString().contains("byg") && !location.toString().equals("minecraft:the_end") && !location.toString().equals("minecraft:small_end_islands") && !location.toString().equals("minecraft:end_barrens")).collect(Collectors.toSet())) {
            if (((Biome)biomeRegistry.func_241873_b(location2).get()).func_201856_r() == Biome.Category.THEEND) {
                BYGEndBiome.endBiomeData.add(new EndBiomeData(location2, 5, new BiomeDictionary.Type[]{BiomeDictionary.Type.END}, (WeightedList<ResourceLocation>)new WeightedList(), null));
            }
            BYGEndBiome.endBiomeData.removeIf(endBiomeData1 -> endBiomeData1.getBiome() == null);
            BYGEndBiome.endBiomeData.sort(Comparator.comparing(data -> data.getBiome().toString()));
        }
    }

    public static void fillBiomeLists() {
        WeightedList end_biomes = new WeightedList();
        WeightedList void_biomes = new WeightedList();
        HashMap<ResourceLocation, WeightedList<ResourceLocation>> biome_to_hills = new HashMap<ResourceLocation, WeightedList<ResourceLocation>>();
        HashMap<ResourceLocation, ResourceLocation> biome_to_edge = new HashMap<ResourceLocation, ResourceLocation>();
        for (EndBiomeData endBiomeData : BYGEndBiome.endBiomeData) {
            if (endBiomeData.getBiomeWeightedList() != null) {
                biome_to_hills.put(endBiomeData.getBiome(), endBiomeData.getBiomeWeightedList());
            }
            if (endBiomeData.getEdgeBiome() != null) {
                biome_to_edge.put(endBiomeData.getBiome(), endBiomeData.getEdgeBiome());
            }
            end_biomes.func_226313_a_((Object)endBiomeData.getBiome(), endBiomeData.getBiomeWeight());
        }
        for (EndBiomeData endBiomeData : BYGEndBiome.voidBiomeData) {
            if (endBiomeData.getBiomeWeightedList() != null) {
                biome_to_hills.put(endBiomeData.getBiome(), endBiomeData.getBiomeWeightedList());
            }
            if (endBiomeData.getEdgeBiome() != null) {
                biome_to_edge.put(endBiomeData.getBiome(), endBiomeData.getEdgeBiome());
            }
            void_biomes.func_226313_a_((Object)endBiomeData.getBiome(), endBiomeData.getBiomeWeight());
        }
        biome_to_hills.entrySet().removeIf(Objects::isNull);
        biome_to_edge.entrySet().removeIf(Objects::isNull);
        end_biomes.field_220658_a.removeIf(Objects::isNull);
        void_biomes.field_220658_a.removeIf(Objects::isNull);
        BYGEndBiomeProvider.END_BIOMES = end_biomes;
        BYGEndBiomeProvider.VOID_BIOMES = void_biomes;
        BYGEndBiome.BIOME_TO_HILLS = biome_to_hills;
        BYGEndBiome.BIOME_TO_EDGE = biome_to_edge;
    }
}

