/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.config.json.endbiomedata.sub;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import corgiaoc.byg.BYG;
import corgiaoc.byg.config.json.endbiomedata.sub.EndSubBiomeData;
import corgiaoc.byg.config.json.endbiomedata.sub.EndSubBiomeDataListHolder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedList;
import net.minecraftforge.common.BiomeDictionary;

public class EndSubBiomeDataListHolderSerializer
implements JsonSerializer<EndSubBiomeDataListHolder>,
JsonDeserializer<EndSubBiomeDataListHolder> {
    public static List<BiomeDictionary.Type> defaultTypesList = new ArrayList<BiomeDictionary.Type>();
    public static List<BiomeDictionary.Type> stopSpamLoggerSpam;

    public JsonElement serialize(EndSubBiomeDataListHolder Src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject biomes = new JsonObject();
        JsonObject endBiomeObject = new JsonObject();
        JsonObject voidBiomeObject = new JsonObject();
        for (EndSubBiomeData endSubBiomeData : Src.getEndSubBiomeData()) {
            JsonObject object = new JsonObject();
            StringBuilder dictionaryString = new StringBuilder();
            for (BiomeDictionary.Type type : endSubBiomeData.getDictionaryTypes()) {
                if (!dictionaryString.toString().isEmpty()) {
                    dictionaryString.append(",");
                }
                dictionaryString.append(type.toString());
            }
            object.addProperty("dictionary", dictionaryString.toString().toUpperCase());
            ResourceLocation edgeKey = endSubBiomeData.getEdgeBiome();
            if (edgeKey != null) {
                object.addProperty("edge", edgeKey.toString());
            } else {
                object.addProperty("edge", "");
            }
            ResourceLocation location = endSubBiomeData.getBiome();
            if (location != null) {
                if (dictionaryString.toString().contains("VOID")) {
                    voidBiomeObject.add(location.toString(), (JsonElement)object);
                    continue;
                }
                endBiomeObject.add(location.toString(), (JsonElement)object);
                continue;
            }
            BYG.LOGGER.error("The Biome key was null! This should NEVER happen.");
        }
        biomes.add("biomes", (JsonElement)endBiomeObject);
        biomes.add("void-biomes", (JsonElement)voidBiomeObject);
        return biomes;
    }

    public EndSubBiomeDataListHolder deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        BYG.LOGGER.info("Reading json");
        JsonObject jsonObject = json.getAsJsonObject();
        ArrayList<EndSubBiomeData> endSubBiomeData = new ArrayList<EndSubBiomeData>();
        ArrayList<EndSubBiomeData> voidSubBiomeData = new ArrayList<EndSubBiomeData>();
        Set entrySet = jsonObject.get("biomes").getAsJsonObject().entrySet();
        Set voidEntrySet = jsonObject.get("void-biomes").getAsJsonObject().entrySet();
        this.extractElements(endSubBiomeData, entrySet);
        this.extractElements(endSubBiomeData, voidEntrySet);
        return new EndSubBiomeDataListHolder(endSubBiomeData, voidSubBiomeData);
    }

    private void extractElements(List<EndSubBiomeData> endSubBiomeData, Set<Map.Entry<String, JsonElement>> entrySet) {
        for (Map.Entry<String, JsonElement> elementEntry : entrySet) {
            WeightedList weightedList = new WeightedList();
            String biomeName = elementEntry.getKey();
            JsonElement element = elementEntry.getValue();
            JsonObject elementObject = element.getAsJsonObject();
            String edge = elementObject.get("edge").getAsString();
            String dictionary = elementObject.get("dictionary").getAsString();
            List<BiomeDictionary.Type> types = Arrays.stream(dictionary.trim().replace(" ", "").toUpperCase().split(",")).map(this::warnIfTagIsNotDefault).map(x$0 -> BiomeDictionary.Type.getType((String)x$0, (BiomeDictionary.Type[])new BiomeDictionary.Type[0])).collect(Collectors.toList());
            BiomeDictionary.Type[] typesArray = new BiomeDictionary.Type[types.size()];
            typesArray = types.toArray(typesArray);
            if (types.size() == 0) {
                types.add(BiomeDictionary.Type.END);
                BYG.LOGGER.warn("No dictionary entries were read...defaulting to: \"END\"");
            }
            ResourceLocation biomeKey = new ResourceLocation(biomeName);
            if (BYG.EARLY_BIOME_REGISTRY_ACCESS.func_148742_b().contains(biomeKey)) {
                endSubBiomeData.add(new EndSubBiomeData(biomeKey, typesArray, new ResourceLocation(edge)));
                continue;
            }
            BYG.LOGGER.error("The biome key: \"" + biomeName + "\" was not found in the dynamic registry, skipping entry...");
        }
    }

    public String warnIfTagIsNotDefault(String string) {
        BiomeDictionary.Type type = BiomeDictionary.Type.getType((String)string, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
        if (!defaultTypesList.contains(type) && !stopSpamLoggerSpam.contains(type)) {
            BYG.LOGGER.warn(type.toString() + " is not a default dictionary value.\nIgnore this msg if using modded biome dictionary values.");
            stopSpamLoggerSpam.add(type);
        }
        return string;
    }

    static {
        defaultTypesList.add(BiomeDictionary.Type.HOT);
        defaultTypesList.add(BiomeDictionary.Type.COLD);
        defaultTypesList.add(BiomeDictionary.Type.SPARSE);
        defaultTypesList.add(BiomeDictionary.Type.DENSE);
        defaultTypesList.add(BiomeDictionary.Type.WET);
        defaultTypesList.add(BiomeDictionary.Type.DRY);
        defaultTypesList.add(BiomeDictionary.Type.SAVANNA);
        defaultTypesList.add(BiomeDictionary.Type.CONIFEROUS);
        defaultTypesList.add(BiomeDictionary.Type.JUNGLE);
        defaultTypesList.add(BiomeDictionary.Type.SPOOKY);
        defaultTypesList.add(BiomeDictionary.Type.DEAD);
        defaultTypesList.add(BiomeDictionary.Type.LUSH);
        defaultTypesList.add(BiomeDictionary.Type.MUSHROOM);
        defaultTypesList.add(BiomeDictionary.Type.MAGICAL);
        defaultTypesList.add(BiomeDictionary.Type.RARE);
        defaultTypesList.add(BiomeDictionary.Type.PLATEAU);
        defaultTypesList.add(BiomeDictionary.Type.MODIFIED);
        defaultTypesList.add(BiomeDictionary.Type.OCEAN);
        defaultTypesList.add(BiomeDictionary.Type.RIVER);
        defaultTypesList.add(BiomeDictionary.Type.WATER);
        defaultTypesList.add(BiomeDictionary.Type.MESA);
        defaultTypesList.add(BiomeDictionary.Type.FOREST);
        defaultTypesList.add(BiomeDictionary.Type.PLAINS);
        defaultTypesList.add(BiomeDictionary.Type.MOUNTAIN);
        defaultTypesList.add(BiomeDictionary.Type.HILLS);
        defaultTypesList.add(BiomeDictionary.Type.SWAMP);
        defaultTypesList.add(BiomeDictionary.Type.SANDY);
        defaultTypesList.add(BiomeDictionary.Type.SNOWY);
        defaultTypesList.add(BiomeDictionary.Type.WASTELAND);
        defaultTypesList.add(BiomeDictionary.Type.VOID);
        defaultTypesList.add(BiomeDictionary.Type.OVERWORLD);
        defaultTypesList.add(BiomeDictionary.Type.BEACH);
        defaultTypesList.add(BiomeDictionary.Type.NETHER);
        defaultTypesList.add(BiomeDictionary.Type.END);
        stopSpamLoggerSpam = new ArrayList<BiomeDictionary.Type>();
    }
}

