/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.autumnity.common.block;

import com.minecraftabnormals.autumnity.common.entity.item.FallingHeadBlockEntity;
import com.minecraftabnormals.autumnity.core.other.AutumnityEvents;
import com.minecraftabnormals.autumnity.core.other.AutumnityFoods;
import com.minecraftabnormals.autumnity.core.registry.AutumnityEffects;
import com.minecraftabnormals.autumnity.core.registry.AutumnityItems;
import com.minecraftabnormals.autumnity.core.registry.AutumnitySoundEvents;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FallingBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TurkeyBlock
extends FallingBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final IntegerProperty CHUNKS = IntegerProperty.func_177719_a((String)"chunks", (int)0, (int)4);
    public static final VoxelShape[] NORTH_SHAPE = new VoxelShape[]{Block.func_208617_a((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)8.0, (double)16.0), Block.func_208617_a((double)1.0, (double)0.0, (double)2.0, (double)13.0, (double)8.0, (double)16.0), Block.func_208617_a((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)8.0, (double)14.0), Block.func_208617_a((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)8.0, (double)10.0), Block.func_208617_a((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)8.0, (double)6.0)};
    public static final VoxelShape[] SOUTH_SHAPE = new VoxelShape[]{Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)8.0, (double)14.0), Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)15.0, (double)8.0, (double)14.0), Block.func_208617_a((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)8.0, (double)14.0), Block.func_208617_a((double)3.0, (double)0.0, (double)6.0, (double)13.0, (double)8.0, (double)14.0), Block.func_208617_a((double)3.0, (double)0.0, (double)10.0, (double)13.0, (double)8.0, (double)14.0)};
    public static final VoxelShape[] WEST_SHAPE = new VoxelShape[]{Block.func_208617_a((double)2.0, (double)0.0, (double)1.0, (double)16.0, (double)8.0, (double)15.0), Block.func_208617_a((double)2.0, (double)0.0, (double)3.0, (double)16.0, (double)8.0, (double)15.0), Block.func_208617_a((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)8.0, (double)13.0), Block.func_208617_a((double)2.0, (double)0.0, (double)3.0, (double)10.0, (double)8.0, (double)13.0), Block.func_208617_a((double)2.0, (double)0.0, (double)3.0, (double)6.0, (double)8.0, (double)13.0)};
    public static final VoxelShape[] EAST_SHAPE = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)14.0, (double)8.0, (double)15.0), Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)14.0, (double)8.0, (double)13.0), Block.func_208617_a((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)8.0, (double)13.0), Block.func_208617_a((double)6.0, (double)0.0, (double)3.0, (double)14.0, (double)8.0, (double)13.0), Block.func_208617_a((double)10.0, (double)0.0, (double)3.0, (double)14.0, (double)8.0, (double)13.0)};

    public TurkeyBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)CHUNKS, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        int i = (Integer)state.func_177229_b((Property)CHUNKS);
        if (state.func_177229_b((Property)FACING) == Direction.NORTH) {
            return NORTH_SHAPE[i];
        }
        if (state.func_177229_b((Property)FACING) == Direction.SOUTH) {
            return SOUTH_SHAPE[i];
        }
        if (state.func_177229_b((Property)FACING) == Direction.WEST) {
            return WEST_SHAPE[i];
        }
        return EAST_SHAPE[i];
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (worldIn.func_175623_d(pos.func_177977_b()) || TurkeyBlock.func_185759_i((BlockState)worldIn.func_180495_p(pos.func_177977_b())) && pos.func_177956_o() >= 0) {
            FallingHeadBlockEntity fallingblockentity = (Integer)state.func_177229_b((Property)CHUNKS) == 0 ? new FallingHeadBlockEntity((World)worldIn, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos)) : new FallingBlockEntity((World)worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos));
            this.func_149829_a(fallingblockentity);
            worldIn.func_217376_c((Entity)fallingblockentity);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            if (this.eatTurkey(worldIn, pos, state, player, itemstack, handIn) == ActionResultType.SUCCESS) {
                return ActionResultType.SUCCESS;
            }
            if (itemstack.func_190926_b()) {
                return ActionResultType.CONSUME;
            }
        }
        return this.eatTurkey(worldIn, pos, state, player, itemstack, handIn);
    }

    private ActionResultType eatTurkey(World worldIn, BlockPos pos, BlockState state, PlayerEntity player, ItemStack itemstack, Hand hand) {
        int i = (Integer)state.func_177229_b((Property)CHUNKS);
        boolean flag = itemstack.func_77973_b() instanceof AxeItem;
        if (player.func_71043_e(false) || flag) {
            if (flag) {
                TurkeyBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)this.getLeg()));
                worldIn.func_184133_a(player, pos, (SoundEvent)AutumnitySoundEvents.BLOCK_TURKEY_CUT.get(), SoundCategory.BLOCKS, 1.0f, (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                itemstack.func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(hand));
            } else {
                ItemStack stack = this.getPickBlock(state, null, (IBlockReader)worldIn, pos, player);
                player.func_184185_a(player.func_213353_d(stack), 1.0f, 1.0f + (worldIn.func_201674_k().nextFloat() - worldIn.func_201674_k().nextFloat()) * 0.4f);
                this.restoreHunger((IWorld)worldIn, player);
            }
            if (i < 4) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)CHUNKS, (Comparable)Integer.valueOf(i + 1)), 3);
            } else {
                worldIn.func_217377_a(pos, false);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    protected void restoreHunger(IWorld worldIn, PlayerEntity player) {
        int i;
        int j;
        player.func_71024_bL().func_75122_a(AutumnityFoods.TURKEY.func_221466_a(), AutumnityFoods.TURKEY.func_221469_b());
        if (!worldIn.func_201670_d() && worldIn.func_201674_k().nextFloat() < 0.1f) {
            player.func_195064_c(new EffectInstance(Effects.field_76438_s, 600, 0));
        }
        int n = j = (i = AutumnityFoods.TURKEY.func_221466_a()) == 1 ? i : (int)((float)i * 0.5f);
        if (player.func_70644_a((Effect)AutumnityEffects.FOUL_TASTE.get())) {
            player.func_71024_bL().func_75122_a(j, 0.0f);
            AutumnityEvents.updateFoulTaste(player);
        }
    }

    protected Item getLeg() {
        return (Item)AutumnityItems.TURKEY_PIECE.get();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, CHUNKS});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return 10 - (Integer)blockState.func_177229_b((Property)CHUNKS) * 2;
    }
}

