/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.autumnity.common.world.gen.feature;

import com.minecraftabnormals.autumnity.core.registry.AutumnityBlocks;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.IPlantable;

public class MapleTreeFeature
extends Feature<BaseTreeFeatureConfig> {
    public MapleTreeFeature(Codec<BaseTreeFeatureConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random random, BlockPos position, BaseTreeFeatureConfig config) {
        int i = random.nextInt(2) + 5;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= worldIn.func_217301_I()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_217301_I()) {
                            if (MapleTreeFeature.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (MapleTreeFeature.isValidGround((IWorld)worldIn, position.func_177977_b()) && position.func_177956_o() < worldIn.func_217301_I() - i - 1) {
                int i2;
                MapleTreeFeature.setDirtAt((IWorld)worldIn, position.func_177977_b());
                for (i2 = 0; i2 < 2; ++i2) {
                    BlockPos blockpos = position.func_177981_b(i - 1 - i2);
                    for (BlockPos blockpos1 : BlockPos.func_218278_a((BlockPos)blockpos.func_177982_a(-2, -1, -2), (BlockPos)blockpos.func_177982_a(2, 3, 2))) {
                        double d0 = blockpos1.func_218140_a((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), false);
                        if (!(d0 <= 5.5224995613098145) && (!(d0 <= 6.25) || random.nextInt(2) <= 0) || !MapleTreeFeature.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, blockpos1)) continue;
                        this.placeLeafAt((IWorldGenerationReader)worldIn, blockpos1, random, config);
                    }
                }
                for (i2 = 0; i2 < i; ++i2) {
                    if (!MapleTreeFeature.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, position.func_177981_b(i2))) continue;
                    this.placeLogAt((IWorldWriter)worldIn, position.func_177981_b(i2), random, config);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeLogAt(IWorldWriter worldIn, BlockPos pos, Random rand, BaseTreeFeatureConfig config) {
        this.setLogState(worldIn, pos, config.field_227368_m_.func_225574_a_(rand, pos));
    }

    private void placeLeafAt(IWorldGenerationReader world, BlockPos pos, Random rand, BaseTreeFeatureConfig config) {
        if (MapleTreeFeature.isAirOrLeaves((IWorldGenerationBaseReader)world, pos)) {
            this.setLogState((IWorldWriter)world, pos, (BlockState)config.field_227369_n_.func_225574_a_(rand, pos).func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1)));
        }
    }

    protected final void setLogState(IWorldWriter worldIn, BlockPos pos, BlockState state) {
        worldIn.func_180501_a(pos, state, 19);
    }

    public static boolean isAir(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        if (!(worldIn instanceof IBlockReader)) {
            return worldIn.func_217375_a(pos, AbstractBlock.AbstractBlockState::func_196958_f);
        }
        return worldIn.func_217375_a(pos, state -> state.isAir((IBlockReader)worldIn, pos));
    }

    public static boolean isAirOrLeaves(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        if (worldIn instanceof IWorldReader) {
            return worldIn.func_217375_a(pos, state -> state.canBeReplacedByLeaves((IWorldReader)worldIn, pos));
        }
        return worldIn.func_217375_a(pos, state -> state.func_196958_f() || state.func_235714_a_((ITag)BlockTags.field_206952_E));
    }

    public static void setDirtAt(IWorld worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_196658_i || block == Blocks.field_150458_ak) {
            worldIn.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 18);
        }
    }

    public static boolean isValidGround(IWorld world, BlockPos pos) {
        return world.func_180495_p(pos).canSustainPlant((IBlockReader)world, pos, Direction.UP, (IPlantable)AutumnityBlocks.MAPLE_SAPLING.get());
    }
}

