/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.autumnity.core.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.minecraftabnormals.autumnity.common.world.gen.feature.FallenLeavesFeature;
import com.minecraftabnormals.autumnity.common.world.gen.feature.FallenLeavesMapleTreeFeature;
import com.minecraftabnormals.autumnity.common.world.gen.feature.MapleTreeFeature;
import com.minecraftabnormals.autumnity.common.world.gen.feature.PumpkinFieldsPumpkinFeature;
import com.minecraftabnormals.autumnity.core.registry.AutumnityBlocks;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.DoublePlantBlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.SingleRandomFeature;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoiseDependant;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AutumnityFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"autumnity");
    public static final RegistryObject<Feature<BaseTreeFeatureConfig>> MAPLE_TREE = FEATURES.register("maple_tree", () -> new MapleTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_));
    public static final RegistryObject<Feature<BaseTreeFeatureConfig>> FALLEN_LEAVES_MAPLE_TREE = FEATURES.register("fallen_leaves_maple_tree", () -> new FallenLeavesMapleTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> FALLEN_LEAVES = FEATURES.register("fallen_leaves", () -> new FallenLeavesFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Feature<NoFeatureConfig>> PUMPKIN_FIELDS_PUMPKIN = FEATURES.register("pumpkin_fields_pumpkin", () -> new PumpkinFieldsPumpkinFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    public static final class Configured {
        public static final ConfiguredFeature<?, ?> MAPLE_TREE_GREEN = ((Feature)MAPLE_TREE.get()).func_225566_b_((IFeatureConfig)Configs.MAPLE_TREE_CONFIG);
        public static final ConfiguredFeature<?, ?> MAPLE_TREE_YELLOW = ((Feature)FALLEN_LEAVES_MAPLE_TREE.get()).func_225566_b_((IFeatureConfig)Configs.YELLOW_MAPLE_TREE_CONFIG);
        public static final ConfiguredFeature<?, ?> MAPLE_TREE_ORANGE = ((Feature)FALLEN_LEAVES_MAPLE_TREE.get()).func_225566_b_((IFeatureConfig)Configs.ORANGE_MAPLE_TREE_CONFIG);
        public static final ConfiguredFeature<?, ?> MAPLE_TREE_RED = ((Feature)MAPLE_TREE.get()).func_225566_b_((IFeatureConfig)Configs.RED_MAPLE_TREE_CONFIG);
        public static final ConfiguredFeature<?, ?> MAPLE_TREE = MAPLE_TREE_GREEN.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.01f, 1)));
        public static final ConfiguredFeature<?, ?> FALLEN_LEAVES = ((Feature)FALLEN_LEAVES.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_((ConfiguredPlacement)Features.Placements.field_244002_m.func_242729_a(32));
        public static final ConfiguredFeature<?, ?> MAPLE_VEGETATION = Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)Features.field_243860_bF.func_227227_a_(0.025f), (Object)Features.field_243861_bG.func_227227_a_(0.05f), (Object)MAPLE_TREE_RED.func_227227_a_(0.3f), (Object)MAPLE_TREE_ORANGE.func_227227_a_(0.4f), (Object)MAPLE_TREE_YELLOW.func_227227_a_(0.2f)), MAPLE_TREE_GREEN)).func_227228_a_(Features.Placements.field_244001_l);
        public static final ConfiguredFeature<?, ?> MAPLE_FOREST_VEGETATION = MAPLE_VEGETATION.func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 1)));
        public static final ConfiguredFeature<?, ?> PUMPKIN_FIELDS_VEGETATION = MAPLE_VEGETATION.func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.2f, 1)));
        public static final ConfiguredFeature<?, ?> PATCH_ROSE_BUSH = Feature.field_227248_z_.func_225566_b_((IFeatureConfig)Configs.ROSE_BUSH_CONFIG);
        public static final ConfiguredFeature<?, ?> PATCH_FOUL_BERRY_BUSH = (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)Configs.TALL_FOUL_BERRY_BUSH_CONFIG).func_227228_a_(Features.Placements.field_244002_m).func_242729_a(1);
        public static final ConfiguredFeature<?, ?> PATCH_GRASS_MAPLE_FOREST = (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)Features.Configs.field_243983_g).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(1);
        public static final ConfiguredFeature<?, ?> PATCH_GRASS_PUMPKIN_FIELDS = ((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)Features.Configs.field_243983_g).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_243994_e).func_242728_a()).func_227228_a_(Placement.field_242900_d.func_227446_a_((IPlacementConfig)new NoiseDependant(-0.8, 5, 10)));
        public static final ConfiguredFeature<?, ?> PATCH_PUMPKINS_PUMPKIN_FIELDS = (ConfiguredFeature)((Feature)PUMPKIN_FIELDS_PUMPKIN.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(5);
        public static final ConfiguredFeature<?, ?> FLOWER_AUTUMN_CROCUS = Feature.field_227247_y_.func_225566_b_((IFeatureConfig)Configs.AUTUMN_CROCUS_CONFIG);
        public static final ConfiguredFeature<?, ?> FLOWER_OXEYE_DAISY = Feature.field_227247_y_.func_225566_b_((IFeatureConfig)Configs.CORNFLOWER_CONFIG);
        public static final ConfiguredFeature<?, ?> FLOWER_CORNFLOWER = Feature.field_227247_y_.func_225566_b_((IFeatureConfig)Configs.OXEYE_DAISY_CONFIG);
        public static final ConfiguredFeature<?, ?> FLOWER_MAPLE_FOREST = (ConfiguredFeature)Feature.field_204620_ao.func_225566_b_((IFeatureConfig)new SingleRandomFeature((List)ImmutableList.of(() -> PATCH_ROSE_BUSH, () -> FLOWER_AUTUMN_CROCUS))).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(4);
        public static final ConfiguredFeature<?, ?> FLOWER_PUMPKIN_FIELDS = Feature.field_204620_ao.func_225566_b_((IFeatureConfig)new SingleRandomFeature((List)ImmutableList.of(() -> FLOWER_OXEYE_DAISY, () -> FLOWER_CORNFLOWER, () -> FLOWER_AUTUMN_CROCUS))).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242900_d.func_227446_a_((IPlacementConfig)new NoiseDependant(-0.8, 15, 4)));

        private static <FC extends IFeatureConfig> void register(String name, ConfiguredFeature<FC, ?> configuredFeature) {
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("autumnity", name), configuredFeature);
        }

        public static void registerConfiguredFeatures() {
            Configured.register("maple_tree_green", MAPLE_TREE_GREEN);
            Configured.register("maple_tree_yellow", MAPLE_TREE_YELLOW);
            Configured.register("maple_tree_orange", MAPLE_TREE_ORANGE);
            Configured.register("maple_tree_red", MAPLE_TREE_RED);
            Configured.register("maple_tree", MAPLE_TREE);
            Configured.register("fallen_leaves", FALLEN_LEAVES);
            Configured.register("maple_vegetation", MAPLE_VEGETATION);
            Configured.register("maple_forest_vegetation", MAPLE_FOREST_VEGETATION);
            Configured.register("pumpkin_fields_vegetation", PUMPKIN_FIELDS_VEGETATION);
            Configured.register("patch_rose_bush", PATCH_ROSE_BUSH);
            Configured.register("patch_grass_foul_berry_bush", PATCH_FOUL_BERRY_BUSH);
            Configured.register("patch_grass_maple_forest", PATCH_GRASS_MAPLE_FOREST);
            Configured.register("patch_grass_pumpkin_fields", PATCH_GRASS_PUMPKIN_FIELDS);
            Configured.register("patch_pumpkins_pumpkin_fields", PATCH_PUMPKINS_PUMPKIN_FIELDS);
            Configured.register("flower_autumn_crocus", FLOWER_AUTUMN_CROCUS);
            Configured.register("flower_oxeye_daisy", FLOWER_OXEYE_DAISY);
            Configured.register("flower_cornflower", FLOWER_CORNFLOWER);
            Configured.register("flower_maple_forest", FLOWER_MAPLE_FOREST);
            Configured.register("flower_pumpkin_fields", FLOWER_PUMPKIN_FIELDS);
        }
    }

    public static final class Configs {
        public static final BaseTreeFeatureConfig MAPLE_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(States.access$000()), (BlockStateProvider)new SimpleBlockStateProvider(States.access$100()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242252_a((int)0), 0), (AbstractTrunkPlacer)new StraightTrunkPlacer(0, 0, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0)).func_236700_a_().func_225568_b_();
        public static final BaseTreeFeatureConfig YELLOW_MAPLE_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(States.access$000()), (BlockStateProvider)new SimpleBlockStateProvider(States.access$200()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242252_a((int)0), 0), (AbstractTrunkPlacer)new StraightTrunkPlacer(0, 0, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0)).func_236700_a_().func_225568_b_();
        public static final BaseTreeFeatureConfig ORANGE_MAPLE_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(States.access$000()), (BlockStateProvider)new SimpleBlockStateProvider(States.access$300()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242252_a((int)0), 0), (AbstractTrunkPlacer)new StraightTrunkPlacer(0, 0, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0)).func_236700_a_().func_225568_b_();
        public static final BaseTreeFeatureConfig RED_MAPLE_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(States.access$000()), (BlockStateProvider)new SimpleBlockStateProvider(States.access$400()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242252_a((int)0), 0), (AbstractTrunkPlacer)new StraightTrunkPlacer(0, 0, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0)).func_236700_a_().func_225568_b_();
        public static final BlockClusterFeatureConfig TALL_FOUL_BERRY_BUSH_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(States.access$500()), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227316_a_((Set)ImmutableSet.of((Object)Blocks.field_196658_i)).func_227317_b_().func_227322_d_();
        public static final BlockClusterFeatureConfig AUTUMN_CROCUS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(States.access$600()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
        public static final BlockClusterFeatureConfig ROSE_BUSH_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(States.access$700()), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
        public static final BlockClusterFeatureConfig OXEYE_DAISY_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(States.access$800()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
        public static final BlockClusterFeatureConfig CORNFLOWER_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(States.access$900()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    }

    public static final class States {
        private static final BlockState MAPLE_LOG = ((Block)AutumnityBlocks.MAPLE_LOG.get()).func_176223_P();
        private static final BlockState MAPLE_LEAVES = ((Block)AutumnityBlocks.MAPLE_LEAVES.get()).func_176223_P();
        private static final BlockState YELLOW_MAPLE_LEAVES = ((Block)AutumnityBlocks.YELLOW_MAPLE_LEAVES.get()).func_176223_P();
        private static final BlockState ORANGE_MAPLE_LEAVES = ((Block)AutumnityBlocks.ORANGE_MAPLE_LEAVES.get()).func_176223_P();
        private static final BlockState RED_MAPLE_LEAVES = ((Block)AutumnityBlocks.RED_MAPLE_LEAVES.get()).func_176223_P();
        private static final BlockState TALL_FOUL_BERRY_BUSH = (BlockState)((Block)AutumnityBlocks.TALL_FOUL_BERRY_BUSH.get()).func_176223_P().func_206870_a((Property)SweetBerryBushBlock.field_220125_a, (Comparable)Integer.valueOf(3));
        private static final BlockState AUTUMN_CROCUS = ((Block)AutumnityBlocks.AUTUMN_CROCUS.get()).func_176223_P();
        private static final BlockState ROSE_BUSH = Blocks.field_196802_gf.func_176223_P();
        private static final BlockState OXEYE_DAISY = Blocks.field_196616_bl.func_176223_P();
        private static final BlockState CORNFLOWER = Blocks.field_222387_by.func_176223_P();

        static /* synthetic */ BlockState access$000() {
            return MAPLE_LOG;
        }

        static /* synthetic */ BlockState access$100() {
            return MAPLE_LEAVES;
        }

        static /* synthetic */ BlockState access$200() {
            return YELLOW_MAPLE_LEAVES;
        }

        static /* synthetic */ BlockState access$300() {
            return ORANGE_MAPLE_LEAVES;
        }

        static /* synthetic */ BlockState access$400() {
            return RED_MAPLE_LEAVES;
        }

        static /* synthetic */ BlockState access$500() {
            return TALL_FOUL_BERRY_BUSH;
        }

        static /* synthetic */ BlockState access$600() {
            return AUTUMN_CROCUS;
        }

        static /* synthetic */ BlockState access$700() {
            return ROSE_BUSH;
        }

        static /* synthetic */ BlockState access$800() {
            return OXEYE_DAISY;
        }

        static /* synthetic */ BlockState access$900() {
            return CORNFLOWER;
        }
    }
}

