/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.savageandravage.common.entity.goals;

import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;

public class ImprovedCrossbowGoal<T extends CreatureEntity & ICrossbowUser>
extends Goal {
    private final T entity;
    private CrossbowState crossbowStateUnCharged = CrossbowState.UNCHARGED;
    private final double speedChanger;
    private final float radiusSq;
    private int seeTime;
    private int wait;
    private final double blocksUntilBackupSq;

    public ImprovedCrossbowGoal(T entity, double speedChanger, float radius, double blocksUntilBackup) {
        this.entity = entity;
        this.speedChanger = speedChanger;
        this.radiusSq = radius * radius;
        this.blocksUntilBackupSq = blocksUntilBackup;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    private boolean hasCrossbowOnMainHand() {
        return this.entity.func_184614_ca().func_77973_b() instanceof CrossbowItem;
    }

    private boolean isAttackTargetStillExisting() {
        return this.entity.func_70638_az() != null && this.entity.func_70638_az().func_70089_S();
    }

    public boolean func_75250_a() {
        return this.isAttackTargetStillExisting() && this.hasCrossbowOnMainHand();
    }

    public boolean func_75253_b() {
        return this.isAttackTargetStillExisting() && (this.func_75250_a() || !this.entity.func_70661_as().func_75500_f()) && this.hasCrossbowOnMainHand();
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.entity.func_213395_q(false);
        this.entity.func_70624_b(null);
        this.seeTime = 0;
        if (this.entity.func_184587_cr()) {
            this.entity.func_184602_cy();
            ((ICrossbowUser)this.entity).func_213671_a(false);
        }
    }

    public void func_75246_d() {
        boolean shouldMoveTowardsEnemy;
        LivingEntity target = this.entity.func_70638_az();
        this.entity.func_213395_q(true);
        if (target == null) {
            return;
        }
        boolean canSeeEnemy = this.entity.func_70635_at().func_75522_a((Entity)target);
        this.seeTime = canSeeEnemy ? ++this.seeTime : 0;
        double distanceSq = target.func_70068_e(this.entity);
        double distance = target.func_70032_d(this.entity);
        if (distance <= this.blocksUntilBackupSq && !(this.entity.func_70638_az() instanceof AbstractVillagerEntity)) {
            this.entity.func_70625_a((Entity)target, 30.0f, 30.0f);
            this.entity.func_70605_aq().func_188488_a(this.entity.func_184587_cr() ? -0.5f : -3.0f, 0.0f);
        }
        boolean bl = shouldMoveTowardsEnemy = (distanceSq > (double)this.radiusSq || this.seeTime < 5) && this.wait == 0;
        if (shouldMoveTowardsEnemy) {
            this.entity.func_70661_as().func_75497_a((Entity)target, this.isCrossbowUncharged() ? this.speedChanger : this.speedChanger * 0.5);
        } else {
            this.entity.func_70661_as().func_75499_g();
        }
        this.entity.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
        if (this.crossbowStateUnCharged == CrossbowState.UNCHARGED) {
            if (canSeeEnemy) {
                this.entity.func_184598_c(ProjectileHelper.func_221274_a(this.entity, (Item)Items.field_222114_py));
                this.crossbowStateUnCharged = CrossbowState.CHARGING;
                ((ICrossbowUser)this.entity).func_213671_a(true);
            }
        } else if (this.crossbowStateUnCharged == CrossbowState.CHARGING) {
            int i;
            if (!this.entity.func_184587_cr()) {
                this.crossbowStateUnCharged = CrossbowState.UNCHARGED;
            }
            if ((i = this.entity.func_184612_cw()) >= CrossbowItem.func_220026_e((ItemStack)this.entity.func_184607_cu())) {
                this.entity.func_184597_cx();
                this.crossbowStateUnCharged = CrossbowState.CHARGED;
                this.wait = 20 + this.entity.func_70681_au().nextInt(20);
                if (this.entity.func_184592_cb().func_77973_b() instanceof FireworkRocketItem) {
                    this.entity.func_184598_c(Hand.OFF_HAND);
                }
                ((ICrossbowUser)this.entity).func_213671_a(false);
            }
        } else if (this.crossbowStateUnCharged == CrossbowState.CHARGED) {
            --this.wait;
            if (this.wait == 0) {
                this.crossbowStateUnCharged = CrossbowState.READY_TO_ATTACK;
            }
        } else if (this.crossbowStateUnCharged == CrossbowState.READY_TO_ATTACK && canSeeEnemy) {
            ((IRangedAttackMob)this.entity).func_82196_d(target, 1.0f);
            CrossbowItem.func_220011_a((ItemStack)this.entity.func_184586_b(ProjectileHelper.func_221274_a(this.entity, (Item)Items.field_222114_py)), (boolean)false);
            this.crossbowStateUnCharged = CrossbowState.UNCHARGED;
        }
    }

    private boolean isCrossbowUncharged() {
        return this.crossbowStateUnCharged == CrossbowState.UNCHARGED;
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

