/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.style;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.gui.style.display.DisplayColor;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.type.Color;

public class GuiStyle {
    public static final ResourceLocation DEFAULT_STYLE_LOCATION = new ResourceLocation("creativecore", "gui/default_style.json");
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final Gson GSON = new Gson();
    private static final JsonParser PARSER = new JsonParser();
    public static GuiStyle defaultStyle;
    private static HashMap<String, GuiStyle> cachedStyles;
    @SerializedName(value="font-color")
    public Color fontColor = new Color(255, 255, 255);
    @SerializedName(value="font-color-highlight")
    public Color fontColorHighlight = new Color(255, 255, 200);
    @SerializedName(value="border-width")
    public int borderWidth = 1;
    @SerializedName(value="border-thick-width")
    public int borderThickWidth = 2;
    public StyleDisplay disabled = new DisplayColor(0.0f, 0.0f, 0.0f, 0.4f);
    public StyleDisplay border = new DisplayColor(0.0f, 0.0f, 0.0f, 1.0f);
    @SerializedName(value="border-thick")
    public StyleDisplay borderThick = new DisplayColor(0.0f, 0.0f, 0.0f, 1.0f);
    public StyleDisplay background = new DisplayColor(0.6f, 0.6f, 0.6f, 1.0f);
    @SerializedName(value="secondary-background")
    public StyleDisplay secondaryBackground = new DisplayColor(0.5f, 0.5f, 0.5f, 1.0f);
    public StyleDisplay bar = new DisplayColor(0.1f, 0.1f, 0.1f, 1.0f);
    public StyleDisplay clickable = new DisplayColor(0.4f, 0.4f, 0.4f, 1.0f);
    @SerializedName(value="clickable-highlight")
    public StyleDisplay clickableHighlight = new DisplayColor(0.5f, 0.5f, 0.5f, 1.0f);

    public static void reload() {
        try {
            IResource resource = mc.func_195551_G().func_199002_a(DEFAULT_STYLE_LOCATION);
            JsonObject root = PARSER.parse(IOUtils.toString((InputStream)resource.func_199027_b(), (Charset)Charsets.UTF_8)).getAsJsonObject();
            defaultStyle = (GuiStyle)GSON.fromJson((JsonElement)root, GuiStyle.class);
            cachedStyles.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
            CreativeCore.LOGGER.error("Could not load default style");
            defaultStyle = new GuiStyle();
        }
    }

    public static GuiStyle getStyle(String name) {
        GuiStyle cached = cachedStyles.get(name);
        if (cached != null) {
            return cached;
        }
        try {
            IResource resource = mc.func_195551_G().func_199002_a(new ResourceLocation(name));
            JsonObject root = PARSER.parse(IOUtils.toString((InputStream)resource.func_199027_b(), (Charset)Charsets.UTF_8)).getAsJsonObject();
            cached = (GuiStyle)GSON.fromJson((JsonElement)root, GuiStyle.class);
            cachedStyles.put(name, cached);
            return cached;
        }
        catch (FileNotFoundException e) {
            return defaultStyle;
        }
        catch (Exception e) {
            e.printStackTrace();
            CreativeCore.LOGGER.error("Found invalid style " + name);
            return defaultStyle;
        }
    }

    static {
        cachedStyles = new HashMap();
    }
}

