/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.style.display;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.lang.reflect.Type;
import java.util.HashMap;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.style.display.DisplayColor;

@OnlyIn(value=Dist.CLIENT)
@JsonAdapter(value=StyleDisplayDeserializer.class)
public abstract class StyleDisplay {
    private static HashMap<String, Class<? extends StyleDisplay>> types = new HashMap();

    public static void registerType(String id, Class<? extends StyleDisplay> clazz) {
        if (types.containsKey(id)) {
            throw new IllegalArgumentException(id + " is already taken");
        }
        types.put(id, clazz);
    }

    public void render(MatrixStack matrix, int x, int y, int width, int height) {
        matrix.func_227860_a_();
        this.render(matrix.func_227866_c_().func_227870_a_(), x, y, width, height);
        matrix.func_227865_b_();
    }

    protected abstract void render(Matrix4f var1, int var2, int var3, int var4, int var5);

    static {
        StyleDisplay.registerType("color", DisplayColor.class);
    }

    public static class StyleDisplayDeserializer
    implements JsonDeserializer<StyleDisplay> {
        public StyleDisplay deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonObject()) {
                throw new JsonParseException("style display cannot be a property");
            }
            if (!json.getAsJsonObject().has("type")) {
                throw new JsonParseException("missing type in style display");
            }
            Class clazz = (Class)types.get(json.getAsJsonObject().get("type").getAsString());
            if (clazz == null) {
                throw new JsonParseException("style display type not found " + json.getAsJsonObject().get("type"));
            }
            return (StyleDisplay)context.deserialize(json, (Type)clazz);
        }
    }
}

