/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds;

import cpw.mods.modlauncher.api.INameMappingService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.GameSettings;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import team.creative.ambientsounds.AmbientSound;
import team.creative.ambientsounds.AmbientSounds;

public class AmbientSoundEngine {
    public SoundHandler handler;
    public GameSettings settings;
    private List<AmbientSound.SoundStream> sounds = new ArrayList<AmbientSound.SoundStream>();

    public static Field findField(Class<?> classToAccess, String fieldName) {
        try {
            Field f = classToAccess.getDeclaredField(ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.FIELD, (String)fieldName));
            f.setAccessible(true);
            return f;
        }
        catch (ObfuscationReflectionHelper.UnableToFindFieldException e) {
            AmbientSounds.LOGGER.error("Unable to locate field {} ({}) on type {}", (Object)fieldName, (Object)ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.FIELD, (String)fieldName), (Object)classToAccess.getName(), (Object)e);
            AmbientSounds.LOGGER.error("Unable to access field {} ({}) on type {}", (Object)fieldName, (Object)ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.FIELD, (String)fieldName), (Object)classToAccess.getName(), (Object)e);
            throw new RuntimeException("Unable to access field=" + fieldName, e);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to find field=" + fieldName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int playingCount() {
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            return this.sounds.size();
        }
    }

    public AmbientSoundEngine(SoundHandler handler, GameSettings settings) {
        this.settings = settings;
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            Double mute = null;
            try {
                for (AmbientSound.SoundStream sound : this.sounds) {
                    double soundMute = sound.mute();
                    if (!(soundMute > 0.0) || mute != null && !(mute < soundMute)) continue;
                    mute = soundMute;
                }
                Iterator<AmbientSound.SoundStream> iterator = this.sounds.iterator();
                while (iterator.hasNext()) {
                    boolean playing;
                    AmbientSound.SoundStream sound;
                    sound = iterator.next();
                    if (!this.handler.func_215294_c((ISound)sound)) {
                        if (!sound.hasPlayedOnce()) continue;
                        playing = false;
                    } else {
                        playing = true;
                    }
                    if (sound.hasPlayedOnce() && !playing) {
                        sound.onFinished();
                        this.handler.func_147683_b((ISound)sound);
                        iterator.remove();
                        continue;
                    }
                    if (!sound.hasPlayedOnce() && playing) {
                        sound.setPlayedOnce();
                    }
                    if (mute == null || sound.mute() >= mute) {
                        sound.generatedVoume = (float)sound.volume;
                        continue;
                    }
                    sound.generatedVoume = (float)(sound.volume * (1.0 - mute));
                }
            }
            catch (ConcurrentModificationException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(AmbientSound.SoundStream sound) {
        this.handler.func_147683_b((ISound)sound);
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            this.sounds.remove(sound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(AmbientSound.SoundStream stream) {
        this.handler.func_147682_a((ISound)stream);
        stream.onStart();
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            this.sounds.add(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll() {
        List<AmbientSound.SoundStream> list = this.sounds;
        synchronized (list) {
            for (AmbientSound.SoundStream sound : this.sounds) {
                this.stop(sound);
                sound.onFinished();
            }
        }
    }
}

